//=============================================================================
// Dragon.
//=============================================================================
class MSDragon extends MSFlyables;

#exec TEXTURE IMPORT NAME="DragonTex1" FILE="C:\DeusEx\DinoVSHuman1_5\textures\DragonTex2.pcx" GROUP=Skins FLAGS=2

var bool bFlying;

replication
{
     reliable if (Role == ROLE_Authority)
         bFlying;
}

state MSDriving1
{
function Tick(float DeltaTime)
{
  local Actor Other;
  local int X, Y;
//  local vector PassengerDump;
//  local rotator WORKDAMMIT;

  if ((VSize(Velocity) < 1) && (!bFlying))
   LoopAnim('BreatheLight');

//  if (MSCarDriver != None)
//  {
//    SetLocation(MSCarDriver.Location + vect(0,0,1) * CollisionHeight / 2);
//a little calculation to measure how fast the car is going, used for damage calculation.
//    MSCarSpeed = (MSCarDriver.Location.X - MSCarDriver.OldLocation.X) + (MSCarDriver.Location.Y - MSCarDriver.OldLocation.Y);
 if ((LeftGun.IsA('DrivableWeaponRPG')) && (LeftGunPos != LRPGPos))
 {
   LeftGunPos = LRPGPos;
   RightGunPos = RRPGPos;
 }
 if ((!LeftGun.IsA('DrivableWeaponRPG')) && (LeftGunPos == LRPGPos))
 {
   LeftGunPos = Default.LeftGunPos;
   RightGunPos = Default.RightGunPos;
 }

 if (MSCarDriver == None)
  return;

    MSCarSpeed = VSize(Velocity) / 21.5;
    if (MSCarSpeed < 1) MSCarSpeed = 0;

    if (LastGasTimer > 0) //if the gas timer isnt too low, decrease it
    {
          LastGasTimer -= DeltaTime;
          bStillDriving = True;
    }
  
    if (StallTimer > 0) //if the stall timer isnt too low, decrease it
    {
          StallTimer -= DeltaTime;
    }

    if (LastGasTimer <= 0) //if its been too long, assume we've stopped driving
       if (bStillDriving)
          bStillDriving = False;

                         //UPDATE: added shit for drifting
    if ((!bStillDriving) && (EBrakeTimer <= 0)) //projectile physics dont slow themselves, so lets do that automatically
       if (Velocity != vect(0,0,0))
          Velocity -= Velocity / 20 * 0.4 * BrakeStrength; //minus __% of the speed, maximum of 20%

	if (ShotTimer > 0)
         ShotTimer -= DeltaTime;

      HandleDyingDriver();
    
      HandlePassenger();

      HandleLivingDriver();

    if ((MSCarDriver != None) && (_flyingscreen != None))
     _flyingscreen.SetMessageText(GetDrivingStats());
//  }  
// Super.Tick(DeltaTime);
}

}

state MSDriving2
{
function Tick(float DeltaTime)
{
  local Actor Other;
  local int X, Y;
//  local vector PassengerDump;
//  local rotator WORKDAMMIT;

  if ((VSize(Velocity) < 1) && (!bFlying))
   LoopAnim('BreatheLight');

//  if (MSCarDriver != None)
//  {
//    SetLocation(MSCarDriver.Location + vect(0,0,1) * CollisionHeight / 2);
//a little calculation to measure how fast the car is going, used for damage calculation.
//    MSCarSpeed = (MSCarDriver.Location.X - MSCarDriver.OldLocation.X) + (MSCarDriver.Location.Y - MSCarDriver.OldLocation.Y);
 if ((LeftGun.IsA('DrivableWeaponRPG')) && (LeftGunPos != LRPGPos))
 {
   LeftGunPos = LRPGPos;
   RightGunPos = RRPGPos;
 }
 if ((!LeftGun.IsA('DrivableWeaponRPG')) && (LeftGunPos == LRPGPos))
 {
   LeftGunPos = Default.LeftGunPos;
   RightGunPos = Default.RightGunPos;
 }

 if (MSCarDriver == None)
  return;

    MSCarSpeed = VSize(Velocity) / 21.5;
    if (MSCarSpeed < 1) MSCarSpeed = 0;

    if (LastGasTimer > 0) //if the gas timer isnt too low, decrease it
    {
          LastGasTimer -= DeltaTime;
          bStillDriving = True;
    }
  
    if (StallTimer > 0) //if the stall timer isnt too low, decrease it
    {
          StallTimer -= DeltaTime;
    }

    if (LastGasTimer <= 0) //if its been too long, assume we've stopped driving
       if (bStillDriving)
          bStillDriving = False;

                         //UPDATE: added shit for drifting
    if ((!bStillDriving) && (EBrakeTimer <= 0)) //projectile physics dont slow themselves, so lets do that automatically
       if (Velocity != vect(0,0,0))
          Velocity -= Velocity / 20 * 0.4 * BrakeStrength; //minus __% of the speed, maximum of 20%

	if (ShotTimer > 0)
         ShotTimer -= DeltaTime;

      HandleDyingDriver();
    
      HandlePassenger();

      HandleLivingDriver();

    if ((MSCarDriver != None) && (_flyingscreen != None))
     _flyingscreen.SetMessageText(GetDrivingStats());
//  }  
// Super.Tick(DeltaTime);
}
}


auto state Active
{
	function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
		local float avg;

		if (bStatic || bInvincible)
			return;

		if ((DamageType == 'TearGas') || (DamageType == 'PoisonGas') || (DamageType == 'Radiation'))
			return;

		if ((DamageType == 'EMP') || (DamageType == 'NanoVirus') || (DamageType == 'Shocked'))
			return;

		if (DamageType == 'HalonGas')
			ExtinguishFire();

		if ((DamageType == 'Burned') || (DamageType == 'Flamed'))
		{
			if (bExplosive)		// blow up if we are hit by fire
				HitPoints = 0;
			else if (bFlammable && !Region.Zone.bWaterZone)
			{
				GotoState('Burning');
				return;
			}
		}

		if (Damage >= minDamageThreshold)
			HitPoints -= Damage;
		else
		{
			// sabot damage at 50%
			// explosion damage at 25%
			if (damageType == 'Sabot')
				HitPoints -= Damage * 0.5;
			else if (damageType == 'Exploded')
				HitPoints -= Damage * 0.25;
		}

		if (HitPoints > 0)		// darken it to show damage (from 1.0 to 0.1 - don't go completely black)
		{
			ResetScaleGlow();
		}
		else	// destroy it!
		{
			DropThings();
//                        StopMSDriving();
//			bHidden = True;
//			SetCollision(False, False, False);
//                        GoToState('Respawning');

			// clear the event to keep Destroyed() from triggering the event
			Event = '';
			avg = (CollisionRadius + CollisionHeight) / 2;
			Instigator = EventInstigator;
			if (Instigator != None)
				MakeNoise(1.0);

			if (fragType == class'WoodFragment')
			{
				if (avg > 20)
					PlaySound(sound'WoodBreakLarge', SLOT_Misc,,, 512);
				else
					PlaySound(sound'WoodBreakSmall', SLOT_Misc,,, 512);
				AISendEvent('LoudNoise', EAITYPE_Audio, , 512);
			}

			// if we have been blown up, then destroy our contents
			// CNN - don't destroy contents now
//			if (DamageType == 'Exploded')
//			{
//				Contents = None;
//				Content2 = None;
//				Content3 = None;
//			}

			if (bExplosive)
			{
				Frag(fragType, Momentum * explosionRadius / 4, avg/20.0, avg/5 + 1);
				Explode(HitLocation);
			}
			else
				Frag(fragType, Momentum / 10, avg/20.0, avg/5 + 1);
		}
	}
}

function Frob(Actor Frobber, Inventory frobWith)
{
}


simulated function string GetDrivingStats() //to be overridden in custom classes such as helicopters and whatnot 
{
 local string StatsMessage;
 
 StatsMessage = "Current Speed:"$MSCarSpeed * 360000 /16 /5280$" MPH,|n Stats _/10: 1.Speed:"$CarSpeed$",2.Accel:"$MSAccelerationSpeed$",3.Strength:"$BrakeStrength$",|n Weapon: "$LeftGun.GunName$", AmmoLeft: "$(LeftGun.AmmoLeft + RightGun.AmmoLeft) / LeftGun.NumberOfShots$", |n Elevation:"$Location.Z - GarageLocation.Z$"|n Aim Rotation:"$(LeftGun.Rotation.Pitch - LeftGun.AttachmentRotation.Pitch) / 92.555555$"";
 
 return StatsMessage;
}

simulated function MSDriveForward()
{
 if (!bFlying)
  LoopAnim('Run');

 Super.MSDriveForward();
}

simulated function MSDriveBackward()
{
 if (!bFlying)
  LoopAnim('Run');

 Super.MSDriveBackward();
}

simulated function MSFlyUpward()
{
 LoopAnim('Tread');
 bFlying = True;

 Super.MSFlyUpward();
}

simulated function MSFlyDownward()
{
 if (bFlying)
  LoopAnim('Tread');

 Super.MSFlyDownward();
}

event HitWall( vector HitNormal, actor HitWall )
{
 bFlying = False;
 
 Super.HitWall(HitNormal, HitWall);
}

simulated function FireDemGuns() //modified for more bullets, nasty hack!
{
  local DeusExProjectile proj1a, proj1b, proj1c, proj1d, proj1e, proj2a, proj2b, proj2c, proj2d, proj2e;
  local int i;


   if (ShotTimer <= 0)
   {
    proj1a = DeusExProjectile(Spawn(MPProjectileClass, MSCarDriver,, Location + (FiringOffsetL >> (Rotation + LeftGunRot)) , Rotation + LeftGunRot + Rot(0,1,0) * (Rand(1024) - 512) + Rot(1,0,0) * (Rand(1024) - 512)));
    proj1b = DeusExProjectile(Spawn(MPProjectileClass, MSCarDriver,, Location + (FiringOffsetL >> (Rotation + LeftGunRot)) , Rotation + LeftGunRot + Rot(0,1,0) * (Rand(1024) - 512) + Rot(1,0,0) * (Rand(1024) - 512)));
    proj1c = DeusExProjectile(Spawn(MPProjectileClass, MSCarDriver,, Location + (FiringOffsetL >> (Rotation + LeftGunRot)) , Rotation + LeftGunRot + Rot(0,1,0) * (Rand(1024) - 512) + Rot(1,0,0) * (Rand(1024) - 512)));
    proj1d = DeusExProjectile(Spawn(MPProjectileClass, MSCarDriver,, Location + (FiringOffsetL >> (Rotation + LeftGunRot)) , Rotation + LeftGunRot + Rot(0,1,0) * (Rand(1024) - 512) + Rot(1,0,0) * (Rand(1024) - 512)));
    proj1e = DeusExProjectile(Spawn(MPProjectileClass, MSCarDriver,, Location + (FiringOffsetL >> (Rotation + LeftGunRot)) , Rotation + LeftGunRot + Rot(0,1,0) * (Rand(1024) - 512) + Rot(1,0,0) * (Rand(1024) - 512)));
    proj2a = DeusExProjectile(Spawn(MPProjectileClass, MSCarDriver,, Location + (FiringOffsetR >> (Rotation + RightGunRot)) , Rotation + RightGunRot + Rot(0,1,0) * (Rand(1024) - 512) + Rot(1,0,0) * (Rand(1024) - 512)));
    proj2b = DeusExProjectile(Spawn(MPProjectileClass, MSCarDriver,, Location + (FiringOffsetR >> (Rotation + RightGunRot)) , Rotation + RightGunRot + Rot(0,1,0) * (Rand(1024) - 512) + Rot(1,0,0) * (Rand(1024) - 512)));
    proj2c = DeusExProjectile(Spawn(MPProjectileClass, MSCarDriver,, Location + (FiringOffsetR >> (Rotation + RightGunRot)) , Rotation + RightGunRot + Rot(0,1,0) * (Rand(1024) - 512) + Rot(1,0,0) * (Rand(1024) - 512)));
    proj2d = DeusExProjectile(Spawn(MPProjectileClass, MSCarDriver,, Location + (FiringOffsetR >> (Rotation + RightGunRot)) , Rotation + RightGunRot + Rot(0,1,0) * (Rand(1024) - 512) + Rot(1,0,0) * (Rand(1024) - 512)));
    proj2e = DeusExProjectile(Spawn(MPProjectileClass, MSCarDriver,, Location + (FiringOffsetR >> (Rotation + RightGunRot)) , Rotation + RightGunRot + Rot(0,1,0) * (Rand(1024) - 512) + Rot(1,0,0) * (Rand(1024) - 512)));
    PlaySimSound( MPFiringSound, SLOT_None, TransientSoundVolume, 2048 );
    ShotTimer = ShotTime;
   }

}

defaultproperties
{
     Mesh=LODMesh'DeusExCharacters.Greasel'
     Skin=Texture'MSDriving1_2.Skins.DragonTex1'
     DrawScale=2.000000
     CollisionRadius=53.280000
     CollisionHeight=34.000000
     ItemName="Tamed Alpha-Dragon"
     Buoyancy=1000.000000
     HasBombs=False
     CarSpeed=6
     BrakeStrength=4
     MSAccelerationSpeed=2
     bUseGas=False
     LeftGunPos=(X=0,Y=0,Z=40)
     RightGunPos=(X=0,Y=0,Z=40)
     LRPGPos=(X=0,Y=0,Z=40)
     RRPGPos=(X=0,Y=0,Z=40)
     DriverPos=(X=0,Y=0,Z=37)
     FiringOffsetR=(X=60,Y=0,Z=0)
     FiringOffsetL=(X=60,Y=0,Z=0)
     DriverDump=(X=0,Y=85.248,Z=0)
     PassengerDump=(X=0,Y=-85.248,Z=0)
     FlyingScreenType=Class'MSDriving1_2.MenuUIDragonFlyingWindow'
     MPFlyingScreenType=Class'MSDriving1_2.MPMenuUIFlyingWindow'
     DefaultGun=Class'MSDriving1_2.DrivableWeaponDragonFire'
     HitPoints=275
     FragType=Class'DeusEx.FleshFragment'
     ExplosionRadius=0.000000
     ExplosionDamage=0
     VehicleRespawnTime=10.000000
     MPFiringSound=Sound'DeusExSounds.Weapons.FlamethrowerFire'
     ShotTime=0.135000
     MPProjectileClass=Class'DeusEx.Fireball'
     KnownGuns(0)=Class'MSDriving1_2.DrivableWeaponDragonFire'
     KnownGuns(1)=Class'MSDriving1_2.DrivableWeaponDragonFire'
     KnownGuns(2)=Class'MSDriving1_2.DrivableWeaponDragonFire'
     KnownGuns(3)=Class'MSDriving1_2.DrivableWeaponDragonFire'
